require( "quest/m3_permits/convout.lua" );
combine_speech_tables();

--modify this to change correct answers
answers_table =
{ 2, 1, 3, 3, 1, 3, 2, 3 };

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

function advance_round(flo)
	option1 = scene.OPTION1;
	option2 = scene.OPTION2;
	option3 = scene.OPTION3;
	quizbot = scene.QUIZBOT;
	
	round = game:Get("permits_quiz_round");
	round = round + 1;
	
	delay(10);
	
	if round > table.getn(answers_table) then		
		finish_quiz(flo);
	else
		if round > 8 then
			run_super_conversation(flo, "quip_final_question");
		elseif round > 1 then
			run_super_conversation(flo, "quip_next_question");
		end;
		
		--run_super_conversation(flo, "quiz_question" .. round);
		option1:Say("");
		option2:Say("quiz_question" .. round);
		option3:Say("");
		coroutine.yield(RESUME.ON_CLICK);
		
		sfx:PlaySFX("audio/sfx/big_quiz_answers");
		option1:Say("quiz_option" .. round .. "a");
		option2:Say("quiz_option" .. round .. "b");
		option3:Say("quiz_option" .. round .. "c");
		
		option1:LoadZone("option1");
		option2:LoadZone("option2");
		option3:LoadZone("option3");
		
		game:Set("permits_quiz_round", round);
		flo:SetMode(MODE.FOLLOWCLICKS);
	end;
end;

function finish_quiz(flo)
	total = game:Get("permits_quiz_round");
	correct = game:Get("permits_quiz_correct");
	run_super_conversation(flo, "quip_finish_quiz");
	sfx:PlaySFX("audio/sfx/big_quiz_score");
	delay(50);
	
	if total == correct then --pass
		scene.OPTION1:SayRaw("");
		scene.OPTION3:SayRaw("");
		scene.OPTION2:Say("quiz_passed");
		sfx:PlaySFX("audio/sfx/big_quiz_pass");
		run_super_conversation(flo, "conv_complete_quiz");
		flo:SetMode(MODE.FOLLOWCLICKS);
		activity_passed(flo);
		reset_quiz(option1, option2, option3);
	else --fail
		scene.OPTION1:SayRaw("");
		scene.OPTION3:SayRaw("");
		scene.OPTION2:SayRaw(scene:grabformattedstring("quizbot_results", { correct, total }));
		sfx:PlaySFX("audio/sfx/big_quiz_fail");
		run_super_conversation(flo, "quip_fail_quiz");
		--quizbot:SayRaw("You got " .. correct .. " out of " .. total .. " answers correct.", 150);
		--quizbot:SayRaw(scene:grabformattedstring("quizbot_results", { correct, total }));
		--coroutine.yield(RESUME.ON_CLICK);
		run_super_conversation(flo, "quip_retry_quiz");
		
		game:Set("failed_permits_quiz", 1)
		
		reset_quiz(option1, option2, option3);
		
		scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	end;
end;

function reset_quiz()
	game:Set("permits_quiz_round", 0);
	game:Set("permits_quiz_correct", 0);
	
	if scene.OPTION1 then scene.OPTION1:Expire(); end;
	if scene.OPTION2 then scene.OPTION2:Expire(); end;
	if scene.OPTION3 then scene.OPTION3:Expire(); end;
	delay(1);
end;

function submit_answer(flo, answer)
	flo:SetMode(MODE.CUTSCENE);
	
	sfx:PlaySFX("audio/sfx/big_quiz_select");
	option1:DumpZone();
	option2:DumpZone();
	option3:DumpZone();
	--correct
	if answer == answers_table[game:Get("permits_quiz_round")] then
		game:Set("permits_quiz_correct", game:Get("permits_quiz_correct") + 1);
	end;
	flo:StartProc(advance_round);
	--scene.FLO:StartProc(advance_round, quizbot, option1, option2, option3);
end;

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:JumpToNamedPoint("flo");
		actor:Face(DIR.W);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		actor:SetMode(MODE.CUTSCENE);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		actor:FaceNow(DIR.W);
		actor:JumpToNamedPoint("exit_walkto");
		actor:WalkTo("flo_walkto");
		
		game:Set( "visited_permits_office", 1 );
		
		wait_walkto();
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		if game:Get("permits_quiz_round") <= table.getn(answers_table) and game:Get("permits_quiz_round") >= 1 then
			convproc("FLO", "quip_permits_flo_A");
		elseif game:Get("got_permit") == 1 then
			convproc("FLO", "quip_permits_flo_C");
		elseif game:Get("failed_permits_quiz") >= 1 then
			convproc("FLO", "quip_permits_flo_B");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function activity_passed(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("got_permit") < 1 then
		game:Set("got_permit", 1);
		addInventory( inv_desc_permit );
		if IsCheatMode() then
			scene.PASS_ACTIVITY_BUTTON:Expire();
		end
		add_quest("got_permit");
		wait_subscene();
	end;
	
	flo:SetMode(MODE.FOLLOWCLICKS);
	
	-- save progress
	game:SaveGame();
end;

function quizbot_click(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("got_permit") < 1 then
		if game:Get("permits_quiz_round") <= 0 then --setup quiz
			if game:Get("clicked_quizbot") <= 0 then
				run_super_conversation(flo, "conv_quiz_intro");
				game:Set("clicked_quizbot", 1);
			else
				run_super_conversation(flo, "conv_quiz_return");
			end;
			
			reset_quiz();
			option1 = scene:Spawn(option1_spec);
			option2 = scene:Spawn(option2_spec);
			option3 = scene:Spawn(option3_spec);
			
			flo:FaceActor(scene.QUIZBOT);
			advance_round(flo);
		else
			flo:SetMode(MODE.FOLLOWCLICKS);
		end;
	elseif game:Get("called_colin") <= 0 then
		run_super_conversation(flo, "conv_got_permit");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		run_super_conversation(flo, "conv_permit_stamped");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end;
end;

quizbot_spec = 
{
	name = "QUIZBOT";
	halo = "quest/objects/robot";
	gfx = { anim = "anim/robot/talk"};
	
	command = function(actor)
		actor:JumpToNamedPoint("robot");
		prepare_actor_text(actor, quizbot_text_spec);
		actor:SetDepthValue(430);
		actor:FaceNow(DIR.E);
	end;
	
	on_arrive = function (flo, quizbot)
		flo:FaceActor(quizbot);
		flo:StartProc(quizbot_click);
	end;
	
	on_use_inv = function(item, flo, quizbot)
		convproc("FLO", "quip_quizbot_reject");
	end;
}

function gotolanding13(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("flo");
	wait_walkto();
	goto_scene(flo, "m3_landing13");
end

exit_spec = 
{
	name = "EXIT";
	halo = "exit";
	cursor = "cursor_arrow_e";
	goto_fn = gotolanding13;
};

option1_spec =
{
	name = "OPTION1";
	
	command = function(actor)
		--actor:SetDepthValue(DEPTH.FRONTMOST);
		actor:ModifySaySpec
		{
		--[[
			--font = "fonts/jokerman.mvec",
			color = { a = 1, r = 145, g = 247, b = 174 },
			outline_size = 1,
			x = 0,
			y = 0,
			h = 50,
			lineheight = 50,
			anchor = ANCHOR.TOP,
			--]]
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 0, g = 0, b = 0},
			--outline_size = 1,
			x = 275,
			y = 185,
			h = 40,
			w = 200,
			lineheight = 20,
			bubble = false,
			anchor = ANCHOR.CENTER,
			halign = HALIGN.CENTER
		};
	end;
	
	on_click = function(flo, actor)
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0},
		};
		actor:Say("quiz_option" .. game:Get("permits_quiz_round") .. "a");
		
		if game:Get("permits_quiz_round") > 0 then
			submit_answer(flo, 1);
		end;
	end;
	
	point_at_fn = function(actor, enter)
		if scene.FLO:GetMode() ~= MODE.CUTSCNE then
			if enter then
				sfx:PlaySFX("audio/sfx/button_rollover");
				actor:ModifySaySpec
				{
					color = { a = 1, r = 0, g = 1, b = 0},
				};
			else
				actor:ModifySaySpec
				{
					color = { a = 1, r = 0, g = 0, b = 0},
				};
			end
			
			actor:Say("quiz_option" .. game:Get("permits_quiz_round") .. "a");
		end
	end;
};

option2_spec =
{
	name = "OPTION2";
	
	command = function(actor)
		--actor:SetDepthValue(DEPTH.FRONTMOST);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 0, g = 0, b = 0},
			--outline_size = 1,
			x = 275,
			y = 230,
			h = 80,
			w = 200,
			lineheight = 20,
			bubble = false,
			anchor = ANCHOR.CENTER,
			halign = HALIGN.CENTER
		};
	end;
	
	on_click = function(flo, actor)
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0},
		};
		actor:Say("quiz_option" .. game:Get("permits_quiz_round") .. "b");
	
		if game:Get("permits_quiz_round") > 0 then
			submit_answer(flo, 2);
		end;
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			sfx:PlaySFX("audio/sfx/button_rollover");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 1, b = 0},
			};
		else
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0},
			};
		end
		
		actor:Say("quiz_option" .. game:Get("permits_quiz_round") .. "b");
	end;
};

option3_spec =
{
	name = "OPTION3";
	
	command = function(actor)
		--actor:SetDepthValue(DEPTH.FRONTMOST);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 0, g = 0, b = 0},
			--outline_size = 1,
			x = 275,
			y = 280,
			h = 40,
			w = 200,
			lineheight = 20,
			bubble = false,
			anchor = ANCHOR.CENTER,
			halign = HALIGN.CENTER
		};
	end;
	
	on_click = function(flo, actor)
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0},
		};
		actor:Say("quiz_option" .. game:Get("permits_quiz_round") .. "c");
	
		if game:Get("permits_quiz_round") > 0 then
			submit_answer(flo, 3);
		end;
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			sfx:PlaySFX("audio/sfx/button_rollover");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 1, b = 0},
			};
		else
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0},
			};
		end
		
		actor:Say("quiz_option" .. game:Get("permits_quiz_round") .. "c");
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		--scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
				scene:SetRoomScale(300, 550, 1.0, 1.0);	--topline, bottomline, topscale, bottomscale

		fade_scene_up();
		reset_quiz();
		
		if IsCheatMode() then
			if game:Get("got_permit") < 1 then
				spawn_button(pass_activity_button_spec);
			end;
		end;
		
		spawn_nav_arrow(exit_spec);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "counter", 425 },
		{ "left_front_chair", DEPTH.DEPTH_FRONTMOST },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		
		quizbot_spec,
		
		scene_setup,
	};
};
